/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.recipe.serializer;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import mekanism.api.SerializerHelper;
import mekanism.api.chemical.slurry.SlurryStack;
import mekanism.api.recipes.FluidSlurryToSlurryRecipe;
import mekanism.api.recipes.chemical.FluidChemicalToChemicalRecipe;
import mekanism.api.recipes.ingredients.ChemicalStackIngredient;
import mekanism.api.recipes.ingredients.FluidStackIngredient;
import mekanism.api.recipes.ingredients.creator.IngredientCreatorAccess;
import mekanism.common.Mekanism;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.crafting.RecipeSerializer;
import org.jetbrains.annotations.NotNull;

public class FluidSlurryToSlurryRecipeSerializer<RECIPE extends FluidSlurryToSlurryRecipe>
implements RecipeSerializer<RECIPE> {
    private final IFactory<RECIPE> factory;

    public FluidSlurryToSlurryRecipeSerializer(IFactory<RECIPE> factory) {
        this.factory = factory;
    }

    @NotNull
    public RECIPE fromJson(@NotNull ResourceLocation recipeId, @NotNull JsonObject json) {
        JsonArray fluidInput = GsonHelper.m_13885_((JsonObject)json, (String)"fluidInput") ? GsonHelper.m_13933_((JsonObject)json, (String)"fluidInput") : GsonHelper.m_13930_((JsonObject)json, (String)"fluidInput");
        FluidStackIngredient fluidIngredient = (FluidStackIngredient)IngredientCreatorAccess.fluid().deserialize((JsonElement)fluidInput);
        JsonArray slurryInput = GsonHelper.m_13885_((JsonObject)json, (String)"slurryInput") ? GsonHelper.m_13933_((JsonObject)json, (String)"slurryInput") : GsonHelper.m_13930_((JsonObject)json, (String)"slurryInput");
        ChemicalStackIngredient.SlurryStackIngredient slurryIngredient = (ChemicalStackIngredient.SlurryStackIngredient)IngredientCreatorAccess.slurry().deserialize((JsonElement)slurryInput);
        SlurryStack output = SerializerHelper.getSlurryStack(json, "output");
        if (output.isEmpty()) {
            throw new JsonSyntaxException("Recipe output must not be empty.");
        }
        return this.factory.create(recipeId, fluidIngredient, slurryIngredient, output);
    }

    public RECIPE fromNetwork(@NotNull ResourceLocation recipeId, @NotNull FriendlyByteBuf buffer) {
        try {
            FluidStackIngredient fluidInput = (FluidStackIngredient)IngredientCreatorAccess.fluid().read(buffer);
            ChemicalStackIngredient.SlurryStackIngredient slurryInput = (ChemicalStackIngredient.SlurryStackIngredient)IngredientCreatorAccess.slurry().read(buffer);
            SlurryStack output = SlurryStack.readFromPacket(buffer);
            return this.factory.create(recipeId, fluidInput, slurryInput, output);
        }
        catch (Exception e) {
            Mekanism.logger.error("Error reading fluid slurry to slurry recipe from packet.", (Throwable)e);
            throw e;
        }
    }

    public void toNetwork(@NotNull FriendlyByteBuf buffer, @NotNull RECIPE recipe) {
        try {
            ((FluidChemicalToChemicalRecipe)recipe).write(buffer);
        }
        catch (Exception e) {
            Mekanism.logger.error("Error writing fluid slurry to slurry recipe to packet.", (Throwable)e);
            throw e;
        }
    }

    @FunctionalInterface
    public static interface IFactory<RECIPE extends FluidSlurryToSlurryRecipe> {
        public RECIPE create(ResourceLocation var1, FluidStackIngredient var2, ChemicalStackIngredient.SlurryStackIngredient var3, SlurryStack var4);
    }
}

